#include <stdio.h>
#include <common_func_netx50.h>
#include <libc_file_support.h>
#include <libc_mem_support.h>
#include <ToolkitSample.h>
#include <OS_Spi.h>

#define SERDPM_SLAVE 0
#define SERDPM_CONN  1 /* SPI on X6 */

static NX50_SPI_AREA_T* s_ptSpi = (NX50_SPI_AREA_T*) NX50_NETX_SPI1_AREA;

/*****************************************************************************/
/*! Assert chip select
*   \param pvOSDependent OS Dependent parameter to identify card             */
/*****************************************************************************/
void OS_SpiAssert(void* pvOSDependent)
{
  /* Clear tx/rx FIFO */
  s_ptSpi->aulSpi_cr[1] |= (MSK_NX50_spi_cr1_rx_fifo_clr | MSK_NX50_spi_cr1_tx_fifo_clr );
  /* assert chip select */
  s_ptSpi->aulSpi_cr[1] |= (1 << (SRT_NX50_spi_cr1_fss+SERDPM_SLAVE));
}

/*****************************************************************************/
/*! Deassert chip select
*   \param pvOSDependent OS Dependent parameter to identify card             */
/*****************************************************************************/
void OS_SpiDeassert(void* pvOSDependent)
{
  s_ptSpi->aulSpi_cr[1] &= ~(1 << (SRT_NX50_spi_cr1_fss+SERDPM_SLAVE));
}

/*****************************************************************************/
/*! Transfer byte stream via SPI
*   \param pvOSDependent OS Dependent parameter to identify card
*   \param pbSend        Send buffer (NULL for polling)
*   \param pbRecv        Receive buffer (NULL if discard)
*   \param ulLen         Length of SPI transfer                              */
/*****************************************************************************/
void OS_SpiTransfer(void* pvOSDependent, uint8_t* pbSend, uint8_t* pbRecv, uint32_t ulLen)
{
  uint32_t ulTxLen  = ulLen;

  while(ulLen != 0)
  {
    if ((ulTxLen) && (s_ptSpi->ulSpi_sr&MSK_NX50_spi_sr_TNF) && !(s_ptSpi->ulSpi_sr & MSK_NX50_spi_sr_RFF))
    {
      --ulTxLen;
      if (pbSend == NULL)
        s_ptSpi->ulSpi_dr = 0x00;
      else
        s_ptSpi->ulSpi_dr = *(pbSend++);
    }
    if(s_ptSpi->ulSpi_sr & MSK_NX50_spi_sr_RNE)
    {
      --ulLen;
      if (pbRecv == NULL)
        s_ptSpi->ulSpi_dr;
      else
        *(pbRecv++) = s_ptSpi->ulSpi_dr;
    }
  }
}

int main()
{
  #if SERDPM_CONN == 0 /* X5 */
    NX50_MMIO_SetCfg(0, MMIO_CONFIG_SPI1_MOSI, 0, 0);
    NX50_MMIO_SetCfg(1, MMIO_CONFIG_SPI1_MISO, 0, 0);
    NX50_MMIO_SetCfg(2, MMIO_CONFIG_SPI1_CLK,  0, 0);
    NX50_MMIO_SetCfg(3, MMIO_CONFIG_SPI1_CS0N, 0, 0);
    NX50_MMIO_SetCfg(4, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(6, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(5, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(7, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(29, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(31, MMIO_CONFIG_SPI1_CS0N, 0, 0);
  #elif SERDPM_CONN == 1 /* X6 */
    NX50_MMIO_SetCfg(0, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(1, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(2, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(3, MMIO_CONFIG_INPUT, 0, 0);
    NX50_MMIO_SetCfg(4, MMIO_CONFIG_SPI1_MISO, 0, 0);
    NX50_MMIO_SetCfg(6, MMIO_CONFIG_SPI1_MOSI, 0, 0);
    NX50_MMIO_SetCfg(5, MMIO_CONFIG_SPI1_CLK,  0, 0);
    NX50_MMIO_SetCfg(7, MMIO_CONFIG_SPI1_CS0N, 0, 0);
    NX50_MMIO_SetCfg(29, MMIO_CONFIG_SPI1_CS0N, 0, 0);
    NX50_MMIO_SetCfg(31, MMIO_CONFIG_INPUT, 0, 0);
  #endif

  NX50_MMIO_SetCfg(34, MMIO_CONFIG_UART0_RXD, 0, 0);
  NX50_MMIO_SetCfg(35, MMIO_CONFIG_UART0_TXD, 0, 0);
  

  /* Libc memory initialiation */
  libc_mem_init();
  
  /* Init the libc part & redirect printf output to uart */
  libc_file_init();
 
  /* setup SPI Core data width and enable static nCS handling */
  s_ptSpi->aulSpi_cr[0]  = 7 << SRT_NX50_spi_cr0_datasize;

  /* clock divider for SCK  to achieve 12,5MHz*/
  s_ptSpi->aulSpi_cr[0] |= ((12500 * 4096 / 100000) << SRT_NX50_spi_cr0_sck_muladd) & MSK_NX50_spi_cr0_sck_muladd;

  /* SPI Mode 3 */
  s_ptSpi->aulSpi_cr[0] |= MSK_NX50_spi_cr0_SPH | MSK_NX50_spi_cr0_SPO;
  /* Clear fifos, set cs mode */
  s_ptSpi->aulSpi_cr[1] = MSK_NX50_spi_cr1_rx_fifo_clr | (8 << SRT_NX50_spi_cr1_rx_fifo_wm) |
                          MSK_NX50_spi_cr1_tx_fifo_clr | (8 << SRT_NX50_spi_cr1_tx_fifo_wm) |
                          MSK_NX50_spi_cr1_fss_static  | MSK_NX50_spi_cr1_SSE;
        
  ToolkitSample();
  
  while (1);
}